import { Home, Store, ClipboardList, ShoppingBag, UserCircle } from "lucide-react";
import { useNavigate, useLocation } from "react-router-dom";
import { useCart } from "@/contexts/CartContext";
import { useAuth } from "@/contexts/AuthContext";

const BottomBar = () => {
  const navigate = useNavigate();
  const location = useLocation();
  const { items, setIsCartOpen } = useCart();
  const { user } = useAuth();

  const totalItems = items.reduce((s, i) => s + i.quantity, 0);

  const isActive = (path: string) => location.pathname === path;

  if (location.pathname.startsWith("/admin")) return null;

  const navItems = [
    {
      icon: Home,
      label: "Home",
      onClick: () => navigate("/"),
      active: isActive("/"),
    },
    {
      icon: Store,
      label: "Shop",
      onClick: () => navigate("/shop"),
      active: isActive("/shop"),
    },
    {
      icon: ClipboardList,
      label: "Orders",
      onClick: () => navigate(user ? "/orders" : "/auth"),
      active: isActive("/orders"),
    },
    {
      icon: ShoppingBag,
      label: "Cart",
      onClick: () => setIsCartOpen(true),
      active: false,
      badge: totalItems > 0 ? totalItems : undefined,
    },
    {
      icon: UserCircle,
      label: "Profile",
      onClick: () => navigate(user ? "/profile" : "/auth"),
      active: isActive("/profile") || isActive("/auth"),
    },
  ];

  return (
    <>
      <div className="h-16 md:hidden" />
      <nav className="fixed bottom-0 left-0 right-0 z-50 bg-card border-t border-border md:hidden">
        <div className="flex items-center justify-around h-16">
          {navItems.map((item) => (
            <button
              key={item.label}
              onClick={item.onClick}
              className={`flex flex-col items-center justify-center gap-0.5 flex-1 h-full relative transition-colors ${
                item.active
                  ? "text-primary"
                  : "text-muted-foreground hover:text-foreground"
              }`}
            >
              <div className="relative">
                <item.icon className={`h-[22px] w-[22px] ${item.active ? "stroke-[2.2]" : "stroke-[1.5]"}`} />
                {item.badge && (
                  <span className="absolute -top-1.5 -right-2.5 bg-primary text-primary-foreground text-[10px] font-bold rounded-full h-4 min-w-4 flex items-center justify-center px-1">
                    {item.badge}
                  </span>
                )}
              </div>
              <span className="text-[10px] font-medium">{item.label}</span>
            </button>
          ))}
        </div>
      </nav>
    </>
  );
};

export default BottomBar;
