import { BookOpen, Layout, Code, Palette, Camera, Music } from "lucide-react";

const categories = [
  { icon: BookOpen, name: "ই-বুক", count: "১২০+", color: "bg-primary/10 text-primary" },
  { icon: Layout, name: "টেমপ্লেট", count: "৮৫+", color: "bg-accent/10 text-accent" },
  { icon: Code, name: "সফটওয়্যার", count: "৬০+", color: "bg-primary/10 text-primary" },
  { icon: Palette, name: "ডিজাইন", count: "৯৫+", color: "bg-accent/10 text-accent" },
  { icon: Camera, name: "ফটোগ্রাফি", count: "৫০+", color: "bg-primary/10 text-primary" },
  { icon: Music, name: "অডিও/ভিডিও", count: "৪০+", color: "bg-accent/10 text-accent" },
];

const Categories = () => {
  return (
    <section id="categories" className="py-20 bg-secondary/50">
      <div className="container mx-auto px-4 md:px-6">
        <div className="text-center mb-12">
          <h2 className="font-heading text-3xl md:text-4xl font-bold text-foreground">
            ক্যাটাগরি <span className="text-gradient-accent">ব্রাউজ</span> করুন
          </h2>
          <p className="text-muted-foreground mt-2">আপনার পছন্দের ক্যাটাগরি থেকে প্রোডাক্ট খুঁজুন</p>
        </div>

        <div className="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-6 gap-4">
          {categories.map((cat, i) => {
            const Icon = cat.icon;
            return (
              <div
                key={cat.name}
                className="group flex flex-col items-center gap-3 p-6 bg-card rounded-lg border border-border hover:border-primary/30 hover:shadow-lg hover:shadow-primary/5 transition-all duration-300 cursor-pointer animate-scale-in"
                style={{ animationDelay: `${i * 0.08}s` }}
              >
                <div className={`p-3 rounded-lg ${cat.color} transition-transform group-hover:scale-110`}>
                  <Icon className="h-6 w-6" />
                </div>
                <h3 className="font-heading font-semibold text-sm text-foreground">{cat.name}</h3>
                <span className="text-xs text-muted-foreground">{cat.count} প্রোডাক্ট</span>
              </div>
            );
          })}
        </div>
      </div>
    </section>
  );
};

export default Categories;
