import ProductCard from "./ProductCard";

const products = [
  {
    title: "ফ্রিল্যান্সিং মাস্টারক্লাস - সম্পূর্ণ গাইড",
    creator: "রাকিব হাসান",
    price: "৳৪৯৯",
    originalPrice: "৳৯৯৯",
    image: "https://images.unsplash.com/photo-1516321318423-f06f85e504b3?w=600&h=450&fit=crop",
    rating: 5,
    category: "কোর্স",
  },
  {
    title: "প্রফেশনাল রিজিউমে টেমপ্লেট প্যাক",
    creator: "নুসরাত জাহান",
    price: "৳১৯৯",
    image: "https://images.unsplash.com/photo-1586281380349-632531db7ed4?w=600&h=450&fit=crop",
    rating: 4,
    category: "টেমপ্লেট",
  },
  {
    title: "UI/UX ডিজাইন কিট - ৫০০+ কম্পোনেন্ট",
    creator: "আরিফ রহমান",
    price: "৳৭৯৯",
    originalPrice: "৳১,৪৯৯",
    image: "https://images.unsplash.com/photo-1561070791-2526d30994b5?w=600&h=450&fit=crop",
    rating: 5,
    category: "ডিজাইন",
  },
  {
    title: "ডিজিটাল মার্কেটিং ই-বুক বাংলায়",
    creator: "সাবরিনা আক্তার",
    price: "৳২৯৯",
    image: "https://images.unsplash.com/photo-1432888498266-38ffec3eaf0a?w=600&h=450&fit=crop",
    rating: 4,
    category: "ই-বুক",
  },
  {
    title: "ওয়ার্ডপ্রেস থিম - eCommerce Pro",
    creator: "তানভীর আহমেদ",
    price: "৳৫৯৯",
    originalPrice: "৳১,১৯৯",
    image: "https://images.unsplash.com/photo-1467232004584-a241de8bcf5d?w=600&h=450&fit=crop",
    rating: 5,
    category: "সফটওয়্যার",
  },
  {
    title: "ফটোগ্রাফি প্রিসেট - Lightroom প্যাক",
    creator: "মিতু দাস",
    price: "৳৩৪৯",
    image: "https://images.unsplash.com/photo-1554048612-b6a482bc67e5?w=600&h=450&fit=crop",
    rating: 4,
    category: "গ্রাফিক্স",
  },
];

const FeaturedProducts = () => {
  return (
    <section id="products" className="py-20 bg-background">
      <div className="container mx-auto px-4 md:px-6">
        <div className="flex items-end justify-between mb-10">
          <div>
            <h2 className="font-heading text-3xl md:text-4xl font-bold text-foreground">
              জনপ্রিয় <span className="text-gradient-primary">প্রোডাক্ট</span>
            </h2>
            <p className="text-muted-foreground mt-2">সেরা ক্রিয়েটরদের সেরা প্রোডাক্ট</p>
          </div>
          <a href="#" className="text-sm font-medium text-primary hover:underline hidden sm:block">
            সব দেখুন →
          </a>
        </div>

        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 gap-6">
          {products.map((product, i) => (
            <div key={i} className="animate-fade-up" style={{ animationDelay: `${i * 0.1}s` }}>
              <ProductCard {...product} />
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

export default FeaturedProducts;
