import { useEffect, useState, useCallback } from "react";
import { supabase } from "@/integrations/supabase/client";
import heroBg from "@/assets/hero-new.jpg";

const HeroBanner = () => {
  const [images, setImages] = useState<string[]>([heroBg]);
  const [current, setCurrent] = useState(0);

  useEffect(() => {
    const fetchBanners = async () => {
      const { data } = await supabase
        .from("banners")
        .select("image_url")
        .eq("is_active", true)
        .not("image_url", "is", null)
        .order("created_at", { ascending: false });
      if (data && data.length > 0) {
        const urls = data.map((b) => b.image_url).filter(Boolean) as string[];
        if (urls.length > 0) setImages(urls);
      }
    };
    fetchBanners();
  }, []);

  const next = useCallback(() => {
    setCurrent((prev) => (prev + 1) % images.length);
  }, [images.length]);

  useEffect(() => {
    if (images.length <= 1) return;
    const interval = setInterval(next, 4000);
    return () => clearInterval(interval);
  }, [next, images.length]);

  return (
    <section className="w-full relative overflow-hidden">
      <div
        className="flex transition-transform duration-700 ease-in-out"
        style={{ transform: `translateX(-${current * 100}%)` }}
      >
        {images.map((url, i) => (
          <img
            key={i}
            src={url}
            alt={`Banner ${i + 1}`}
            className="w-full h-auto block flex-shrink-0"
            style={{ minWidth: "100%" }}
          />
        ))}
      </div>
      {images.length > 1 && (
        <div className="absolute bottom-3 left-1/2 -translate-x-1/2 flex gap-2">
          {images.map((_, i) => (
            <button
              key={i}
              onClick={() => setCurrent(i)}
              className={`w-2.5 h-2.5 rounded-full transition-colors ${
                i === current ? "bg-primary" : "bg-white/60"
              }`}
            />
          ))}
        </div>
      )}
    </section>
  );
};

export default HeroBanner;
