import { useState } from "react";
import { Menu, X, ShoppingCart, Search } from "lucide-react";
import { Button } from "@/components/ui/button";

const Navbar = () => {
  const [isOpen, setIsOpen] = useState(false);

  return (
    <nav className="fixed top-0 left-0 right-0 z-50 bg-background/80 backdrop-blur-lg border-b border-border">
      <div className="container mx-auto px-4 md:px-6">
        <div className="flex items-center justify-between h-16">
          <a href="/" className="font-heading text-xl font-bold text-foreground tracking-tight">
            ডিজি<span className="text-gradient-primary">মার্কেট</span>
          </a>

          <div className="hidden md:flex items-center gap-8">
            <a href="#products" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors">প্রোডাক্ট</a>
            <a href="#categories" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors">ক্যাটাগরি</a>
            <a href="#" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors">ক্রিয়েটর হন</a>
          </div>

          <div className="hidden md:flex items-center gap-3">
            <Button variant="ghost" size="icon">
              <Search className="h-4 w-4" />
            </Button>
            <Button variant="ghost" size="icon" className="relative">
              <ShoppingCart className="h-4 w-4" />
              <span className="absolute -top-1 -right-1 h-4 w-4 rounded-full bg-gradient-accent text-[10px] font-bold text-accent-foreground flex items-center justify-center">
                0
              </span>
            </Button>
            <Button variant="default" size="sm">লগইন</Button>
          </div>

          <button className="md:hidden" onClick={() => setIsOpen(!isOpen)}>
            {isOpen ? <X className="h-5 w-5" /> : <Menu className="h-5 w-5" />}
          </button>
        </div>

        {isOpen && (
          <div className="md:hidden py-4 border-t border-border animate-fade-in">
            <div className="flex flex-col gap-3">
              <a href="#products" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors py-2">প্রোডাক্ট</a>
              <a href="#categories" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors py-2">ক্যাটাগরি</a>
              <a href="#" className="text-sm font-medium text-muted-foreground hover:text-foreground transition-colors py-2">ক্রিয়েটর হন</a>
              <Button variant="default" size="sm" className="w-fit">লগইন</Button>
            </div>
          </div>
        )}
      </div>
    </nav>
  );
};

export default Navbar;
