import filmoraImg from "@/assets/products/filmora.png";
import adobeImg from "@/assets/products/adobe-cc.png";
import canvaImg from "@/assets/products/canva-pro.png";
import chatgptImg from "@/assets/products/chatgpt-plus.png";
import vidiqImg from "@/assets/products/vidiq.png";
import capcutImg from "@/assets/products/capcut-pro.png";
import grammarlyImg from "@/assets/products/grammarly.png";
import vpnShieldImg from "@/assets/products/vpn-shield.png";
import nordvpnImg from "@/assets/products/nordvpn.png";
import expressvpnImg from "@/assets/products/expressvpn.png";
import googlePlayImg from "@/assets/products/google-play-gift.png";
import appleGiftImg from "@/assets/products/apple-gift.png";
import visaCardImg from "@/assets/products/visa-card.png";
import midjourneyImg from "@/assets/products/midjourney.png";
import googleDriveImg from "@/assets/products/google-drive.png";
import youtubeImg from "@/assets/products/youtube-premium.png";
import googleServiceImg from "@/assets/products/google-service.png";

export interface CustomField {
  label: string;
  placeholder?: string;
  required?: boolean;
  helper_text?: string;
}

export interface Product {
  id: number | string;
  name: string;
  slug?: string;
  image: string;
  price: string;
  originalPrice?: string;
  resellerPrice?: string;
  resellerPrices?: Record<string, string>;
  duration?: string[];
  category: string;
  badges?: ("sale" | "limited")[];
  description?: string;
  longDescription?: string;
  features?: string[];
  customFields?: CustomField[];
}

export const allProducts: Product[] = [
  {
    id: 1,
    name: "Wondershare Filmora",
    image: filmoraImg,
    price: "৳450 – ৳3,800",
    category: "Best Products",
    duration: ["1 Month", "3 Month", "6 Month", "12 Month"],
    description: "Wondershare Filmora হলো একটি শক্তিশালী ভিডিও এডিটিং সফটওয়্যার যা প্রফেশনাল-মানের ভিডিও তৈরি করতে সাহায্য করে। সহজ ড্র্যাগ অ্যান্ড ড্রপ ইন্টারফেস, AI-পাওয়ার্ড টুলস, এবং হাজার হাজার ইফেক্ট ও টেমপ্লেট সহ।",
    features: ["AI-Powered Editing Tools", "4K Video Export", "1000+ Effects & Templates", "Screen Recording", "Audio Editing & Noise Removal"],
  },
  {
    id: 2,
    name: "Adobe Creative Cloud",
    image: adobeImg,
    price: "৳250 – ৳800",
    category: "Best Products",
    duration: ["1 Month", "4 Month"],
    description: "Adobe Creative Cloud দিয়ে Photoshop, Illustrator, Premiere Pro, After Effects সহ 20+ প্রিমিয়াম অ্যাপ ব্যবহার করুন।",
    features: ["Photoshop, Illustrator, Premiere Pro", "100GB Cloud Storage", "Adobe Fonts Access", "All Creative Apps", "Regular Updates"],
  },
  {
    id: 3,
    name: "Canva Pro Subscription",
    image: canvaImg,
    price: "৳39 – ৳129",
    category: "Best Products",
    duration: ["1 Month", "1 Year"],
    description: "Canva Pro দিয়ে প্রফেশনাল ডিজাইন তৈরি করুন। ১০০ মিলিয়ন+ প্রিমিয়াম স্টক ফটো, ভিডিও, অডিও এবং গ্রাফিক্স অ্যাক্সেস করুন।",
    features: ["100M+ Premium Stock Photos", "Brand Kit", "Magic Resize", "Background Remover", "Schedule Social Media Posts"],
  },
  {
    id: 4,
    name: "ChatGPT Plus",
    image: chatgptImg,
    price: "৳111 – ৳299",
    category: "Best Products",
    duration: ["Shared", "Personal"],
    description: "ChatGPT Plus দিয়ে GPT-4o মডেল অ্যাক্সেস পান। দ্রুত রেসপন্স, ইমেজ জেনারেশন, ডাটা অ্যানালাইসিস, কোডিং সাহায্য।",
    features: ["GPT-4o Access", "DALL·E Image Generation", "Code Interpreter", "Web Browsing", "Priority Access"],
  },
  {
    id: 5,
    name: "VidiQ Boost Plan",
    image: vidiqImg,
    price: "৳450",
    category: "Best Selling",
    duration: ["1 Month"],
    description: "VidiQ Boost Plan দিয়ে আপনার YouTube চ্যানেল গ্রো করুন। SEO অপটিমাইজেশন, কিওয়ার্ড রিসার্চ সহ।",
    features: ["YouTube SEO Tools", "Keyword Research", "Competitor Analysis", "Trend Alerts", "Channel Analytics"],
  },
  {
    id: 6,
    name: "CapCut Pro",
    image: capcutImg,
    price: "৳299 – ৳2,800",
    category: "Best Selling",
    duration: ["1 Month", "3 Month", "6 Month", "1 Year"],
    description: "CapCut Pro দিয়ে মোবাইল ও ডেস্কটপে প্রফেশনাল ভিডিও এডিট করুন। AI ক্যাপশন, ব্যাকগ্রাউন্ড রিমুভার সহ।",
    features: ["AI Auto Captions", "Background Remover", "Premium Effects & Filters", "Watermark-Free Export", "Cloud Storage"],
  },
  {
    id: 7,
    name: "Grammarly Premium",
    image: grammarlyImg,
    price: "৳199 – ৳899",
    category: "Best Selling",
    duration: ["1 Month", "6 Month"],
    description: "Grammarly Premium দিয়ে আপনার ইংরেজি লেখা প্রফেশনাল করুন। অ্যাডভান্সড গ্রামার চেক, প্লেজিয়ারিজম চেকার সহ।",
    features: ["Advanced Grammar Check", "Tone Detection", "Plagiarism Checker", "AI Writing Suggestions", "Works Everywhere"],
  },
  {
    id: 8,
    name: "Surfshark VPN",
    image: vpnShieldImg,
    price: "৳40",
    category: "VPN",
    duration: ["7 Day"],
    description: "Surfshark VPN দিয়ে আনলিমিটেড ডিভাইসে সিকিউর ব্রাউজিং করুন। ১০০+ দেশে সার্ভার, নো-লগ পলিসি সহ।",
    features: ["Unlimited Devices", "100+ Countries", "No-Log Policy", "Ad Blocker", "Kill Switch"],
  },
  {
    id: 9,
    name: "Nord VPN Subscription",
    image: nordvpnImg,
    price: "৳40",
    category: "VPN",
    duration: ["7 Days"],
    description: "NordVPN দিয়ে আপনার অনলাইন প্রাইভেসি সুরক্ষিত করুন। ৬০+ দেশে ৫,৮০০+ সার্ভার, ডাবল VPN সহ।",
    features: ["5800+ Servers", "Double VPN", "Threat Protection", "6 Devices", "24/7 Support"],
  },
  {
    id: 10,
    name: "Express VPN",
    image: expressvpnImg,
    price: "৳40 – ৳220",
    category: "VPN",
    duration: ["7 Day", "30 Days"],
    description: "ExpressVPN — বিশ্বের সবচেয়ে দ্রুত ও নিরাপদ VPN সার্ভিস। ৯৪টি দেশে সার্ভার, Lightway প্রোটোকল সহ।",
    features: ["94 Countries", "Lightway Protocol", "Split Tunneling", "5 Devices", "No Activity Logs"],
  },
  {
    id: 11,
    name: "Google Play Gift Card – USA",
    image: googlePlayImg,
    price: "৳750 – ৳7,500",
    category: "Gift Card",
    duration: ["$5", "$10", "$20", "$25", "$50"],
    description: "Google Play Gift Card দিয়ে অ্যাপ, গেম, মুভি, বুক এবং আরো অনেক কিছু কিনুন। USA Region, ইনস্ট্যান্ট ডেলিভারি।",
    features: ["Instant Delivery", "USA Region", "Apps, Games, Movies", "No Expiration", "Digital Code"],
  },
  {
    id: 12,
    name: "Apple Gift Card (USD – USA)",
    image: appleGiftImg,
    price: "৳300 – ৳525,000",
    category: "Gift Card",
    duration: ["$5", "$10", "$25", "$50", "$100"],
    description: "Apple Gift Card দিয়ে App Store, iTunes, Apple Music, iCloud+ এবং Apple ডিভাইস কিনুন।",
    features: ["Works for Everything Apple", "Instant Digital Delivery", "USA Region", "No Expiration", "Use for Apps, Music, iCloud"],
  },
  {
    id: 13,
    name: "Virtual Visa Card",
    image: visaCardImg,
    price: "৳219 – ৳499",
    category: "Gift Card",
    duration: ["Redotpay", "Tevau"],
    description: "ভার্চুয়াল Visa কার্ড দিয়ে অনলাইনে যেকোনো পেমেন্ট করুন। ইন্টারন্যাশনাল ট্রানজেকশন সাপোর্ট।",
    features: ["International Payments", "Instant Activation", "Online Shopping", "Subscription Payments", "Secure Transactions"],
  },
  {
    id: 14,
    name: "ChatGPT Plus",
    image: chatgptImg,
    price: "৳111 – ৳299",
    category: "AI Tools",
    duration: ["Shared", "Personal"],
    description: "ChatGPT Plus দিয়ে GPT-4o মডেল অ্যাক্সেস পান। Shared অ্যাকাউন্টে কম দামে অথবা Personal-এ ফুল অ্যাক্সেস।",
    features: ["GPT-4o Access", "DALL·E Image Generation", "Code Interpreter", "Web Browsing", "Priority Access"],
  },
  {
    id: 15,
    name: "Midjourney Subscription",
    image: midjourneyImg,
    price: "৳350 – ৳1,200",
    category: "AI Tools",
    duration: ["1 Month", "3 Month"],
    description: "Midjourney দিয়ে AI-জেনারেটেড আর্ট তৈরি করুন। হাই-কোয়ালিটি ইমেজ জেনারেশন, কমার্শিয়াল লাইসেন্স সহ।",
    features: ["AI Image Generation", "High Resolution Output", "Style Customization", "Commercial License", "Fast Generation"],
  },
  {
    id: 16,
    name: "Claude Pro",
    image: midjourneyImg,
    price: "৳450 – ৳1,500",
    category: "AI Tools",
    duration: ["1 Month", "3 Month"],
    description: "Claude Pro দিয়ে Anthropic-এর সবচেয়ে শক্তিশালী AI মডেল ব্যবহার করুন। লং ডকুমেন্ট অ্যানালাইসিস সহ।",
    features: ["Claude 3.5 Sonnet Access", "200K Token Context", "Priority Access", "File Analysis", "Advanced Reasoning"],
  },
  {
    id: 17,
    name: "Google Drive Subscription",
    image: googleDriveImg,
    price: "৳100 – ৳999",
    category: "Google",
    duration: ["1 Month", "3 Month", "6 Month", "12 Month"],
    description: "Google Drive দিয়ে এক্সট্রা ক্লাউড স্টোরেজ পান। ফাইল শেয়ারিং, কোলাবরেশন সহ।",
    features: ["Extra Cloud Storage", "File Sharing", "Google Workspace Integration", "Cross-Device Sync", "Secure Backup"],
  },
  {
    id: 18,
    name: "YouTube Premium",
    image: youtubeImg,
    price: "৳99 – ৳999",
    category: "Google",
    duration: ["1 Month", "3 Month", "6 Month", "12 Month"],
    description: "YouTube Premium দিয়ে অ্যাড-ফ্রি ভিডিও দেখুন, ব্যাকগ্রাউন্ডে প্লে করুন, অফলাইনে ডাউনলোড করুন।",
    features: ["Ad-Free Videos", "Background Play", "Offline Downloads", "YouTube Music", "YouTube Originals"],
  },
  {
    id: 19,
    name: "Google Service",
    image: googleServiceImg,
    price: "৳149 – ৳1,399",
    badges: ["sale", "limited"],
    category: "Google",
    duration: ["1 Month", "3 Month", "6 Month", "12 Month"],
    description: "Google Service প্যাকেজে Google One, Gmail, Meet প্রিমিয়াম ফিচার সব একসাথে পান।",
    features: ["Google One Storage", "Gmail Premium", "Google Meet Premium", "VPN by Google", "Enhanced Support"],
  },
];

export const getProductById = (id: number): Product | undefined =>
  allProducts.find((p) => p.id === id);

export const getProductsByCategory = (category: string): Product[] =>
  allProducts.filter((p) => p.category === category);

export const bestProducts = allProducts.filter((p) => p.category === "Best Products");
export const bestSelling = allProducts.filter((p) => p.category === "Best Selling");
export const vpnProducts = allProducts.filter((p) => p.category === "VPN");
export const giftCards = allProducts.filter((p) => p.category === "Gift Card");
export const aiTools = allProducts.filter((p) => p.category === "AI Tools");
export const googleProducts = allProducts.filter((p) => p.category === "Google");
