import Header from "@/components/Header";
import ShopFooter from "@/components/ShopFooter";
import { Shield, Zap, Headphones, Award } from "lucide-react";
import { useSiteSettings } from "@/hooks/useSiteSettings";

const About = () => {
  const { settings } = useSiteSettings();
  const features = [
    { icon: Shield, title: "নিরাপদ পেমেন্ট", desc: "আমাদের সকল পেমেন্ট সিস্টেম সম্পূর্ণ নিরাপদ ও এনক্রিপ্টেড।" },
    { icon: Zap, title: "ইনস্ট্যান্ট ডেলিভারি", desc: "পেমেন্ট কনফার্ম হওয়ার সাথে সাথেই আপনি আপনার প্রোডাক্ট পেয়ে যাবেন।" },
    { icon: Headphones, title: "২৪/৭ সাপোর্ট", desc: "আমাদের কাস্টমার সাপোর্ট টিম সবসময় আপনার সেবায় প্রস্তুত।" },
    { icon: Award, title: "অথেনটিক প্রোডাক্ট", desc: "আমরা শুধুমাত্র ১০০% অরিজিনাল ও লাইসেন্সড প্রোডাক্ট বিক্রি করি।" },
  ];

  return (
    <div className="min-h-screen bg-background">
      <Header />
      <div className="container mx-auto px-4 py-12">
        <h1 className="text-3xl font-bold text-foreground text-center mb-4">আমাদের সম্পর্কে</h1>
        <p className="text-muted-foreground text-center max-w-2xl mx-auto mb-12">
          {settings.site_title} বাংলাদেশের অন্যতম বিশ্বস্ত ডিজিটাল প্রোডাক্ট শপ। আমরা সর্বোচ্চ মানের ডিজিটাল প্রোডাক্ট ও সার্ভিস সাশ্রয়ী মূল্যে প্রদান করি।
        </p>
        <div className="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
          {features.map((f) => (
            <div key={f.title} className="bg-card border border-border rounded-xl p-6 text-center">
              <f.icon className="h-10 w-10 text-primary mx-auto mb-4" />
              <h3 className="font-bold text-foreground mb-2">{f.title}</h3>
              <p className="text-sm text-muted-foreground">{f.desc}</p>
            </div>
          ))}
        </div>
      </div>
      <ShopFooter />
    </div>
  );
};

export default About;
