CREATE TABLE public.password_reset_otps (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  phone TEXT NOT NULL,
  otp TEXT NOT NULL,
  expires_at TIMESTAMP WITH TIME ZONE NOT NULL,
  used BOOLEAN NOT NULL DEFAULT false,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

ALTER TABLE public.password_reset_otps ENABLE ROW LEVEL SECURITY;

-- Allow anyone to insert (needed for requesting OTP)
CREATE POLICY "Anyone can request OTP" ON public.password_reset_otps
  FOR INSERT WITH CHECK (true);

-- Allow anyone to read (needed for verification in edge function with service role)
CREATE POLICY "Service can read OTPs" ON public.password_reset_otps
  FOR SELECT USING (true);

-- Allow updates (marking as used)
CREATE POLICY "Service can update OTPs" ON public.password_reset_otps
  FOR UPDATE USING (true);

-- Auto-delete expired OTPs
CREATE POLICY "Service can delete OTPs" ON public.password_reset_otps
  FOR DELETE USING (true);