
-- Product keys/credentials table for auto-delivery
CREATE TABLE public.product_keys (
  id UUID NOT NULL DEFAULT gen_random_uuid() PRIMARY KEY,
  product_id UUID REFERENCES public.products(id) ON DELETE CASCADE NOT NULL,
  key_value TEXT NOT NULL,
  is_sold BOOLEAN NOT NULL DEFAULT false,
  order_id UUID REFERENCES public.orders(id) ON DELETE SET NULL,
  sold_at TIMESTAMP WITH TIME ZONE,
  created_at TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

-- Enable RLS
ALTER TABLE public.product_keys ENABLE ROW LEVEL SECURITY;

-- Admins can manage all keys
CREATE POLICY "Admins can manage product keys" ON public.product_keys
  FOR ALL USING (has_role(auth.uid(), 'admin'::app_role));

-- Users can view their own purchased keys (where order has their user_id)
CREATE POLICY "Users can view own purchased keys" ON public.product_keys
  FOR SELECT USING (
    is_sold = true AND order_id IN (
      SELECT id FROM public.orders WHERE user_id = auth.uid()
    )
  );

-- Index for fast lookup of available keys per product
CREATE INDEX idx_product_keys_available ON public.product_keys (product_id, is_sold) WHERE is_sold = false;
