
CREATE TABLE public.promo_usage (
  id uuid PRIMARY KEY DEFAULT gen_random_uuid(),
  promo_code_id uuid NOT NULL REFERENCES public.promo_codes(id) ON DELETE CASCADE,
  user_id uuid NOT NULL,
  order_id uuid REFERENCES public.orders(id) ON DELETE SET NULL,
  discount_amount numeric NOT NULL DEFAULT 0,
  created_at timestamp with time zone NOT NULL DEFAULT now()
);

ALTER TABLE public.promo_usage ENABLE ROW LEVEL SECURITY;

-- Admins can view all usage
CREATE POLICY "Admins can view all promo usage" ON public.promo_usage
  FOR SELECT USING (has_role(auth.uid(), 'admin'::app_role));

-- Admins can manage promo usage
CREATE POLICY "Admins can manage promo usage" ON public.promo_usage
  FOR ALL USING (has_role(auth.uid(), 'admin'::app_role));

-- Users can view own usage
CREATE POLICY "Users can view own promo usage" ON public.promo_usage
  FOR SELECT USING (user_id = auth.uid());

-- Anyone can insert (needed during checkout)
CREATE POLICY "Anyone can insert promo usage" ON public.promo_usage
  FOR INSERT WITH CHECK (true);
